local SlimUI = ThemePrefs.Get("GameplayMinimalUI")
local t = Def.ActorFrame {};
	--t[#t+1] = LoadActor("_dead");	
	
t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_TOP-35);
	OnCommand=cmd(sleep,0.4;decelerate,0.3;addy,73);
	OffCommand=cmd(sleep,1.0);
	
	LoadFont("Common normal") .. {
		InitCommand=cmd(horizalign,center);
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTraiP1ChangedMessageCommand=cmd(playcommand,"Set");
		CurrentTraiP2ChangedMessageCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			local curScreen = Var "LoadingScreen";
			local curStageIndex = GAMESTATE:GetCurrentStageIndex() + 1;
			local playMode = GAMESTATE:GetPlayMode();
			local curStage = GAMESTATE:GetCurrentStage();
			if GAMESTATE:IsCourseMode() then
				local stats = STATSMAN:GetCurStageStats()
				if not stats then
					return
				end
				local mpStats = stats:GetPlayerStageStats( GAMESTATE:GetMasterPlayerNumber() )
				local songsPlayed = mpStats:GetSongsPassed() + 1
				self:settextf("%i / %i", songsPlayed, GAMESTATE:GetCurrentCourse():GetEstimatedNumStages());
			else
				if GAMESTATE:IsEventMode() then
					self:settextf("FREE");
				else
					if GAMESTATE:IsExtraStage() then
						self:settextf("EXTRA");
					elseif GAMESTATE:IsExtraStage2() then
						self:settextf("ANOTHER");
					else
						self:settextf("%s", ToEnumShortString(string.upper(curStage)));
					end
				end
			end;
			self:zoom(0.75);
			self:diffuse(StageToColor(curStage));
			self:strokecolor(ColorDarkTone(StageToColor(curStage)));
		end;
	};
	
};

	
	-- t[#t+1] = LoadActor("_screenstage") .. {
        -- OnCommand=cmd(sleep,0.3;queuecommand,("Play"));
		-- PlayCommand=cmd(play;);
		
    -- };
	
return t